#include <oxstd.h>
#include <oxfloat.h>
#include "btstrap.ox"

class My_Test:Bootstrap
{
	My_Test();
	BootstrapSample(const mcResids);
	Estimate(const mcZ);
	LoadModel(const mcData);
}

My_Test::My_Test() // constructor function
{
	Bootstrap();
}

My_Test::BootstrapSample(const mcResids)
{
	return Shocks(mcResids, 0);
}

My_Test::Estimate(const mcZ)
{
	decl t = meanc(mcZ)/(varc(mcZ)/rows(mcZ))^(1/2);
	return fabs(t)|t;
}				   											

My_Test::LoadModel(const mcData)
{
	return mcData - meanc(mcData);
}	

/*-----------------------End of Test----------------------*/
main()
{
	decl object = new My_Test();
	decl mcdata = < -0.31,1.98,-0.05,-0.21,-0.30,2.29,1.32,1.63,0.61,0.13,
			-0.11,1.35,0.96,-1.57,-1.06,-0.02, 1.81, -1.09, 0.789, 0.91 >';
	object.Settings(0, {"absolute t", "signed t"});
	object.TestCall(mcdata);
	delete object; 
}
