#include <oxstd.h>
#include <oxfloat.h>
#include "btstrap.ox"

static decl s_vrParam = <0>;// initialize to avoid failure
							// in first call to Estimate
class My_Crit:Bootstrap
{
	My_Crit();
	BootstrapSample(const mcResids);
	Estimate(const mcZ);
	LoadModel(const mcData);
}

My_Crit::My_Crit()	 // constructor
{
	Bootstrap();
}

My_Crit::BootstrapSample(const mcResids)
{
	return Shocks(mcResids, 0);
}

My_Crit::Estimate(const mcZ)
{
	decl m = meanc(mcZ);
	decl s = varc(mcZ)^(1/2);
	return m|s|rows(mcZ)^(1/2)*(m - s_vrParam[0])/s;   
}	

My_Crit::LoadModel(const mcData)
{
	s_vrParam = meanc(mcData);
	return mcData;
}	

main()
{
	decl object = new My_Crit();
		decl mcdata = < -0.31,1.98,-0.05,-0.21,-0.30,2.29,1.32,1.63,0.61,0.13,
			-0.11,1.35,0.96,-1.57,-1.06,-0.02, 1.81, -1.09, 0.789, 0.91 >';
	object.Settings(4, {"mean", "SD", "stud. mean"}, 999);	
	object.TestCall(mcdata);		
	delete object; 
}
