#include <oxstd.h>
#include <oxfloat.h>
#include "btstrap.ox"

static decl s_dParam;
static decl s_mcExog;

class My_Sim:Simulation
{
	My_Sim();
	BootstrapSample(const mcResids);
	Estimate(const mcZ);
	LoadModel(const mcData);
	StoreParams();
	RetrieveParams(const aStore);
	SetupReplication(const dMean);
}

My_Sim::My_Sim()
{
	Simulation();
}

My_Sim::BootstrapSample(const mcResids)
{
	return Shocks(mcResids, 0) + s_mcExog[][:1]*s_dParam;
}

My_Sim::Estimate(const mcZ)
{
	decl beta;
	if(olsc(mcZ, s_mcExog[][:1], &beta) < 1) m_bError = 1;
	decl y = mcZ - s_mcExog[][:1]*beta;
	if(olsc(mcZ, s_mcExog, &beta) < 1) m_bError = 1;
	decl res = mcZ - s_mcExog*beta;
	decl ssq = res'res;
	return (y'y - ssq)/ssq;   
}	

My_Sim::LoadModel(const mcData)
{
	decl beta;
	if(olsc(mcData, s_mcExog[][:1], &beta) < 1) m_bError = 1;
	s_dParam = beta;
	return mcData - s_mcExog[][:1]*beta;
}	

My_Sim::StoreParams()
{
	return s_dParam;
}

My_Sim::RetrieveParams(const aStore)
{
	s_dParam = aStore;
} 


My_Sim::SetupReplication(const dBeta)
{
	s_mcExog = ones(10,1)~(5+2*rann(10,2));
	return s_mcExog*dBeta' + rann(10,1);
}

main()
{
	decl obj = new My_Sim();
	obj.PrintCall(1, "\nRun 1: Simulating the null hypothesis");
	obj.Settings(2, {"pseudo-F stat"}, 199, "sim.txt");
	obj.Simulate(<2, 1, 0>, 1000, 100, "sim.xls");	
	obj.PrintCall(1, "\nRun 2: Simulating alternative b = 0.5");
	obj.Settings(2, {"pseudo-F stat"}, 199,"sim.txt", 0, 0, 0, "sim.xls");	
	obj.Simulate(<2, 1, 0.5>, 1000);	
	delete obj; 
}    
